#### Legacy TCP/IP Vulnerabilities 
![[Pasted image 20250217201130.png]]

Many **early TCP/IP protocols** are now considered **insecure** and vulnerable to various attacks, ranging from password sniffing to denial of service. As an **example**: 

TCP/IP is shipped with Berkeley _r-utilities_.  It's a set of tools featuring: 
**rlogin** - remote login
**rcp** - remote copying 
**rsh** - remote command execution. 

These commands were developed for password-free access to UNIX operating system machines only but they are insecure now. 

Some **other legacy TCP/IP** tools: 

**sendmail** - email routing software 
**finger** - tool to show which users logged in. 

"Morris Worm" - 1988 attack was not written to cause damage but to gauze the size of the  Advanced Research Projects Agency Network (ARPANET). It worked by exploiting vulnerabilities in common utilities such as **sendmail** and **finger**

#### IP Vulnerabilities

**Man-in-the-middle attack** **(MITM)** - Intercepts communication between two systems. A form of MITM is called "eavesdropping."

**Session hijacking:** - The attacker gains physical access to the network, initiates a MITM attack, and then hijacks that session.

**IP address spoofing** - Attackers spoof the source IP address in an IP packet.

**DoS attack** - E.g. *Tear Drop Attack* - the attacker sends IP fragmented packets to a target machine. Since the machine receiving such packets cannot reassemble them due to a bug in TCP/IP fragmentation reassembly, the packets overlap one another, crashing the target network device.

**Distributed Denial of Service (DDoS) attack** - Eg. *Smurf Attack* - Flood with ICMP packets. 

**Resource exhaustion attacks**


#### ICMP Vulnerabilities

ICMP is a connectionless protocol that **does not** use any **port number** and works on the **network layer**. 

Every Network Device must implement ICMP but some admins **block ICMP** to prevent attackers from gathering infromation about their internal network. 

**Security Issues for ICMP:**

**Reconnaissance Scanning** - find live host, network topology, state of a firewall. 
- **ICMP unreachables** - During a port scan, ICMP Port unreachable tells the attacker about port not in use. 
- **ICMP mask reply** - Feature that allows Router to tell the endpoint what is the correct subnet mask. 
- **ICMP redirects** - Feature used by router to notify the sender of a better route but the attacker can send the redirect to a target into sending all traffic via a compromised router. 
- **ICMP router discovery** - IRDP allows hosts to locate routers that can be used as gateway but attackers can perform MITM attack to send all the traffic via another gateway. 
- **Firewalk** - Active Reconnaissance technique. Used to map firewall rules by sending packets with adjusted TTL values to determine which ports and protocols are allowed through a firewall. In firewalking, the TTL (Time-to-Live) value is set to **one hop greater** than the number of hops to the firewall, causing the packet to expire just beyond it; this helps determine if the firewall permits or blocks the traffic based on the type of ICMP response received or the absence of a response.

**ICMP tunneling** - Connection between two remote computers using ICMO echo requests and reply packets. Attackers can transmit data secretly hiding inside ICMP and firewall maynot detect this. A common ICMP tunneling program is **LOKI**.

**ICMP-based operating system fingerprinting** - Process of learning which OS is running on a device. Example - if the ICMP reply contains a TTL value of 128, it is probably a Windows machine, and if the ICMP reply contains a TTL value of 64, it is probably a Linux-based machine.

**Denial of service attacks** - DoS attacks that use ICMP include the following:
- **ICMP flood attack** - flood with ICMP packets such as ICMP echo request (ping)
![[Pasted image 20250225230956.png]]
- **Smurf attack** -  Broadcasts many ICMP echo request packets using a spoofed source IP address (which is the victim's IP address) to a network using an IP broadcast address. The **victim's network will get congested** with all the **ICMP echo replies** traffic, which will bring down the productivity of the entire victim's network.
![[Pasted image 20250225231003.png]]


#### UDP Vulnerabilities

UDP is the transport protocol for several well-known application-layer protocols - NFS, SNMP, DNS, TFTP and real time services such as VoIP , streaming etc. 
#### Attack Surface and Attack Vectors 

![[Pasted image 20250226211830.png]]

![[Pasted image 20250226212254.png]]


#### Reconnaissance Attacks 

The goal of reconnaissance is to gather the information before an actual attack. 

- IP addresses, sub-domains, and related information on a target network.
    
- Accessible UDP and TCP ports on target systems.
    
- The operating system on target systems.


Ways to gather **Network Data**: 

- **Packet sniffers** - Tools, such as Wireshark, Ettercap, or NetworkMiner, give anyone the ability to sniff network traffic with little practice or training.
- **Ping sweeps** - Determine which machines are alive by sending ICMP echo packets. **fping** command 
- **Port scans** - Survey for open ports and find out vulnerable service such as FTP, Telnet, SNMP. Tool - Network Mapper (**Nmap**)
- **Information queries** - nslookup 

**Whois** - gather public information about a target network from the DNS registries

**Shodan Search Engine** - Search engine to find out vulnerabilities linked to a system/service. 
![[Pasted image 20250226221142.png]]


**Robots.txt File** - text file used by websites to communicate with web crawlers and other web robots. It provides instructions on how these robots should interact with the site's pages.

This can be used in reconnaissance attacks because it may reveal the structure of a website and indicate areas that the site owner wishes to keep private or less accessible.

**Example**: 
![[Pasted image 20250226221353.png]]

**Vulnerability Scanners** - An authorized security administrator can use vulnerability scanners, such as **Nessus** and **OpenVAS** to locate vulnerabilities in their own networks and patch them before they can be exploited. Can also be used by an attacker. 

#### Access Attacks
An access attack is an attempt to access another user's account or network device through improper, unauthorized means. The following are some prominent types of attacks:
- **Password attack**
- **Spoofing/masquerading** 
- **Session hijacking** 
- **Malware**

#### Man-In-The-Middle Attacks

**ARP Poisoning** - Attacker poisons the ARP cache of two devices with the MAC address of attacker's NIC. 
![[Pasted image 20250302191136.png]]

**ICMP**-**based MITM attack:**- ICMP redirect message is typically used to notify routers of a better route; however, it can be abused to **route the victim's traffic** through an **attacker controlled router**. The threat of this attack is **mitigated** by routers that have static routes and routers that **do not accept/process ICMP redirect packets**.

**DNS**-**based MITM attack** - Supply false DNS information to a host. 

**DHCP**-**based MITM attack** - Intercept DHCP server queries and responses. An attacker can initiate a DoS attack on a real DHCP server to keep it busy, and in the meanwhile, spoof and respond to the DHCP host queries by itself.

**ARP Cache Poisoning** - **TCP/IP** depends on **ARP** for mapping MAC addresses to the IP addresses on the local subnet, but **there is no authentication of ARP data.**
As such there is weakness to ARP where a threat actor could reply to ARP requests and specify their system's MAC address in the reply and the victim will map the data sent by the threat actor to it's ARP cache. This in turn essentially allows for a MITM situation. 

#### DOS and DDOS 
 ![[Pasted image 20250302203338.png]]
#### Reflection and Amplification Attacks: 
![[Pasted image 20250302203631.png]]

![[Pasted image 20250302204330.png]]

#### Spoofing Attacks 
![[Pasted image 20250302204353.png]]

#### DHCP Attacks 
![[Pasted image 20250302204603.png]]

![[Pasted image 20250302204718.png]]








